﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using GE.Visualisation;
using GE.Physics.Shapes;
using GE.Physics;
using GE.Manager;
using Microsoft.Xna.Framework;
using System.Collections.Generic;

namespace GE.World.Entities
{
    class SpawnerBulletBillEntity : EnemyEntity
    {
        
        int _iDirection;
        int _iAmplitude;
        int _iHorizontalSpeed;
        float _fFrequency;
        int _iLifeTime;

        /// <summary>
        /// Number of Bullet Bill the spawner can handle
        /// </summary>
        int _iCount;

        /// <summary>
        /// Time between respawn
        /// </summary>
        int _iRespawnTime;

        /// <summary>
        /// Time of the last respawn
        /// </summary>
        int _iLastRespawnTime;

        /// <summary>
        /// List of Pogobots entity used by the spawner
        /// </summary>
        List<BulletBillEntity> _listBulletBill;

        #region Properties Editor
        public int Count
        {
            set
            {
                _iCount = value;
                for (int i = 0; i < _iCount; i++)
                {
                    _listBulletBill.Add(World.Instance.createBlankBulletBill());
                }
            }
        }
        public int RespawnTime { set { _iRespawnTime = value; } }
        public int Direction { set { _iDirection = value; } }
        public int Amplitude { set { _iAmplitude = value; } }
        public float Frequency { set { _fFrequency = value; } }
        public int HorizontalSpeed { set { _iHorizontalSpeed = value; } }
        public int LifeTime { set { _iLifeTime = value; } }
#if !GAME
        public static string EDITOR_TILESET { get { return "enemysheet.xml"; } }
        public static string EDITOR_SPRITE { get { return "bullet_bills"; } }
#endif
        #endregion

        /// <summary>
        /// Default constructor
        /// </summary>
        public SpawnerBulletBillEntity()
            :base()
        {
            _listBulletBill = new List<BulletBillEntity>();
        }

        /// <summary>
        /// Activator
        /// </summary>
        /// <param name="position"></param>
        /// <param name="respawnTime"></param>
        public override void activate()
        {
            //_iLifeTime = lifeTime;
            //_v2Position = position;
            _bActive = true;
            _iLastRespawnTime = TimeClock.Clock.instance.millisecs - _iRespawnTime;
            //_iRespawnTime = respawnTime;
            //_iDirection = direction;
            //_iAmplitude = amplitude;
            //_iHorizontalSpeed = hSpeed;
            //_fFrequency = frequency;
        }

        public override void  deactivate()
        {
 	         _bActive = false;
        }

        public override void update()
        {
            //if it appears in the screen => die
            if (ScreenPosition.X > 0 && ScreenPosition.Y > 0 && ScreenPosition.X < Visu.Instance.ScreenWidth &&
                ScreenPosition.Y < Visu.Instance.ScreenHeight)
                die();

            //check if there are only dead entities
            bool bAllDead = true;
            for (int i = 0; i < _iCount; i++)
            {
                if (_listBulletBill[i].Active) 
                    bAllDead = false;
            }
            if (bAllDead)
            {
                spawnEntity(0);
                return;
            }

            //check if the respawn time has elapsed
            if (TimeClock.Clock.instance.millisecs >= _iRespawnTime + _iLastRespawnTime)
            {
                //check if there is a non active entity
                for (int i = 0; i < _iCount; i++)
                {
                    if (!_listBulletBill[i].Active)
                    {
                        //activate a pogobot
                        spawnEntity(i);
                        return;
                    }
                }
            }
        }

        private void spawnEntity(int id)
        {
            //activate a pogobot
            _listBulletBill[id].Position = _v2Position;
            _listBulletBill[id].Direction = _iDirection;
            _listBulletBill[id].Amplitude = _iAmplitude;
            _listBulletBill[id].HorizontalSpeed = _iHorizontalSpeed;
            _listBulletBill[id].Frequency = _fFrequency;
            _listBulletBill[id].LifeTime = _iLifeTime;
            _listBulletBill[id].Damages = Damages;
            _listBulletBill[id].activate();
            _iLastRespawnTime = TimeClock.Clock.instance.millisecs;
        }

        /// <summary>
        /// Kill the entity
        /// </summary>
        public override void die()
        {
            _bActive = false;
        }
    }
}
